function [xRotationAngle, yRotationAngle, zRotationAngle] = convertJsonToAngles(rotationMatrix)
%rewrite rotation matrix to reflect coordinate system changes from scanner to lab frame by cyclic rotation x->y, y->z, z->x, or 0->1, 1->2, 2->0
tmp = rotationMatrix;
%diagonal elemts shift along diagonal
rotationMatrix(1,1) = tmp(3,3);
rotationMatrix(2,2) = tmp(1,1);
rotationMatrix(3,3) = tmp(2,2);
%non diagonal elements rotate in groups of three:
rotationMatrix(2,3) = tmp(1,2);
rotationMatrix(3,1) = tmp(2,3);
rotationMatrix(1,2) = tmp(3,1);

rotationMatrix(2,1) = tmp(1,3);
rotationMatrix(1,3) = tmp(3,2);
rotationMatrix(3,2) = tmp(2,1);

%transform from read file to angles
%three unit vectors of original coordinate system
xAxisOriginal = [1; 0; 0];
yAxisOriginal = [0; 1; 0];
zAxisOriginal = [0; 0; 1];
xAxisNew = rotationMatrix  * xAxisOriginal;
yAxisNew = rotationMatrix  * yAxisOriginal;
zAxisNew = rotationMatrix  * zAxisOriginal;
%normal generated by the two z axes can be used to rotate x and z axes of the new CS back into the x-y-plane of the old CS
normalZ = cross(zAxisOriginal, zAxisNew);
normalZ = normalZ/norm(normalZ);
%angle of back rotation is given by the angle enclosed by the two y axes, old and new
zeta = -1*acos( dot(zAxisOriginal,zAxisNew)) / (norm(zAxisOriginal)*norm(zAxisNew));
zetaDeg = zeta/2/pi*360;
%rotation is generated by a rotation matrix in rodriguez rotation formalism
matrixW = [0, -normalZ(3), normalZ(2); normalZ(3), 0, -normalZ(1); -normalZ(2), normalZ(1), 0];
rodriguezRotationMatrix = eye(3) + sin(zeta) * matrixW + 2 * sin(zeta/2)^2 * matrixW*matrixW;
%execute rotation described above - now z axes coincide again, x and y are in the same plane, not necessarily colinear though
xAxisRotatedBack = rodriguezRotationMatrix * xAxisNew;
yAxisRotatedBack = rodriguezRotationMatrix * yAxisNew;
zAxisRotatedBack = rodriguezRotationMatrix * zAxisNew;
%rotate the coordinate system of the base around the same axis to determine the sensors angular readings in the new position
xAxisAngleCalc = rodriguezRotationMatrix * xAxisOriginal;
yAxisAngleCalc = rodriguezRotationMatrix * yAxisOriginal;
zAxisAngleCalc = rodriguezRotationMatrix * zAxisOriginal;
%The axes z values correspond to the angle of each axis compared to the original x-y-plane, which is what the sensor reads
xRotationAngle = asin(xAxisAngleCalc(3));
yRotationAngle = asin(yAxisAngleCalc(3));
%z rotation is calculated from the angle between backrotated x- and y-axis of the object and original x- and y-axis. It is sufficient to look at the y component of the back-rotated coorinate system (corresponds to dot product with original y axis) and to add the x component's sign.
zRotationAngle = acos(yAxisRotatedBack(2)) * yAxisRotatedBack(1)/abs(yAxisRotatedBack(1));
xRotationAngle = xRotationAngle/2/pi*360;
yRotationAngle = yRotationAngle/2/pi*360;
zRotationAngle = zRotationAngle/2/pi*360;

%yRotationAngle = atan(xAxisRotatedBack(3)/xAxisRotatedBack(1))/2/pi*360;
end